//
//  StaticData.swift
//  Do It
//
//  Created by Jim Dovey on 8/23/19.
//  Copyright © 2019 Jim Dovey. All rights reserved.
//

import Foundation

fileprivate struct TodoData: Decodable {
    var lists: [TodoItemList]
    var items: [TodoItem]
}

fileprivate let todoData: TodoData = loadData(from: Bundle.main.url(forResource: "todo-items", withExtension: "json")!)

let todoItems: [TodoItem] = todoData.items
let todoLists: [TodoItemList] = todoData.lists

extension TodoItem {
    var list: TodoItemList {
        guard let list = todoLists.first(where: { $0.id == self.listID }) else {
            fatalError("No matching list for ID: \(self.listID)")
        }
        return list
    }
}

extension TodoItemList {
    var items: [TodoItem] {
        todoItems.filter { $0.listID == self.id }
    }
}

func loadData<T: Decodable>(from url: URL, as type: T.Type = T.self) -> T {
    do {
        let data = try Data(contentsOf: url, options: [.mappedIfSafe, .uncached])
        let decoder = JSONDecoder()
        decoder.dateDecodingStrategy = .iso8601
        return try decoder.decode(T.self, from: data)
    } catch {
        fatalError("Failed to load JSON data: \(error)")
    }
}
